/************************************************************************************
* Processor specific primitives for enabling/disabling of interrupts.
*
* Author(s): Jesper Thomsen & Knud Dyring-Olsen
*
* (c) Copyright 2004, Freescale, Inc.  All rights reserved.
*
* Freescale Confidential Proprietary
* Digianswer Confidential
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale.
*
* Last Inspected:
* Last Tested:
************************************************************************************
*	History: 
*		10/13/06 - IRQ pin changed for HPRFGW application  
*
************************************************************************************/

#ifndef _HPRFGW_RFIRQCONTROLLIB_H_
	#define _HPRFGW_RFIRQCONTROLLIB_H_

//#include "datatypes.h"
#include "hprfgw_rfSharedDefs.h"
#include "hprfgw_rfEmbeddedTypes.h"
// MNT - 3/19/2007 - Dependency Removal tag begin
//#include "mcf5271_eport.h"
//#include "mcf5271.h"
//#include "init5270.h"
// MNT - 3/19/2007 - Dependency Removal tag end
//#include "IoConfig.h"
//#include "src/init/mcf5xxx.h"
//#include "src/init/m5271evb.h"

extern void EnableMC1319xIrq(void);			
extern void DisableMC1319xIrq(void);	   

//#define	ENABLE_OLD_CALLS

/************************************************************************************
* Keyword to signify that a function must be treated as an interrupt
*   
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
* Revision history:
*   date      Author    Comments
*   ------    ------    --------
*   240505    JT        Created
* 
************************************************************************************/
#define INTERRUPT_KEYWORD __interrupt__ //__declspec(interrupt)
/************************************************************************************/
/************************************************************************************/
// Micro Processor Irq Control
/************************************************************************************/
/************************************************************************************/
//uint32_t asm_set_ipl (uint32_t var);
//uint32 asm_get_ipl (void);

/************************************************************************************
* Primitives to enable/disable all processor interrupts.
* Through immediate access and no backup handles the state of the interrupt mask bit 
* in the status register.
* 
*   
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
* Revision history:
*   date      Author    Comments
*   ------    ------    --------
*   130505    JT        Created
* 
************************************************************************************/
#define IrqControlLib_EnableAllIrqs()      	  {asm_set_ipl(0);}  
#define IrqControlLib_DisableAllIrqs()        {asm("move.w  SR,D0"); asm("ori.l  #0x00000700,D0"); asm("move.w  D0,SR");}

/************************************************************************************
* Primitives to protect/unprotect from processor interrupts.
*   - a safer/slower way of enabling/disabling processor interrupts. 
* Using backup backup of irq status register handles the state
* of the interrupt mask bit in the status register.
* 
* The backup/restore primitives use a local variable for backup.
* The push/pull primitives use the stack. 
*
* NOTE: 
*   While push/pull is slightly faster than backup/restore, it is potentially more risky. 
*   Care must be taken to not corrupt the stack inside the push/pull protection! 
*   
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
* Revision history:
*   date      Author    Comments
*   ------    ------    --------
*   130505    JT        Created
* 
************************************************************************************/
#define IrqControlLib_RestoreIrqStatus(var)		{asm_set_ipl(var);}
#define IrqControlLib_BackupIrqStatus(var)		{var = asm_get_ipl();}
// Alternate way of storing/restoring status register on stack.
// Push/Pull is used, and care must be taken not to mess up the
// stack when using these macros. Compared to IrqControlLib_BackupIrqStatus/
// IrqControlLib_RestoreIrqStatus the push/pull method results in a small
// decrease in code size, and a small increase in execution
// speed
#define IrqControlLib_PushIrqStatus()			{asm("move.w SR,d0"); asm("move.l d0,-(sp)");}
#define IrqControlLib_PullIrqStatus()			{asm("move.l (sp)+,d0"); asm("move.w d0,SR");}

/************************************************************************************/
/************************************************************************************
* Primitives to enable/disable MC1319x interrupts.
* Performed locally on the processors external irq registers
* 
*   
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
* Revision history:
*   date      Author    Comments
*   ------    ------    --------
*   130505    JT        Created
* 
************************************************************************************/
//void IrqControlLib_DisableMC1319xIrq(void);	// {MCF_EPORT_EPIER &= ~0x40;} IRQ pin from MC1319x disabled

/************************************************************************************
* Primitives to protect/unprotect from MC1319x interrupts.
* Performed locally on the processors external irq registers.
* Utilizes a backup/restore approach
* 
*   
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
* Revision history:
*   date      Author    Comments
*   ------    ------    --------
*   130505    JT        Created
* 
************************************************************************************/
#ifdef	ENABLE_OLD_CALLS
	
#else
	#define IrqControlLib_ProtectFromMC1319xIrq(var)      {var = returnEPIER(); IrqControlLib_DisableMC1319xIrq(); }
	#define IrqControlLib_UnprotectFromMC1319xIrq(var)    {restoreEPIER(var);}
#endif

/************************************************************************************
* Primitive to check if irq is (still) asserted by MC1319x.
* Checks irq pin state through processors external irq registers.
* Used to ensure that predicted ISRs like Tx/RxStream, which clear the MC1319x irq source 
* does not require redundant read of the MC1319x interrupt status register (0x24).
* 
*   
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
* Revision history:
*   date      Author    Comments
*   ------    ------    --------
*   130505    JT        Created
* 
************************************************************************************/
#ifdef	ENABLE_OLD_CALLS

#else
#define IrqControlLib_IsMC1319xIrqAsserted()          (isMC1319xIrqAsserted())
#endif

/************************************************************************************
* Primitive to init/setup MC1319x interrupts in the processor.
* Enables external interrupt from MC1319x and configures the processor external irq
* to react to active low and edge-triggered irq.
*   
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
* Revision history:
*   date      Author    Comments
*   ------    ------    --------
*   130505    JT        Created
* 
************************************************************************************/

/************************************************************************************
* Primitive to acknowledge MC1319x interrupts in the processors external irq register.
* Clears latched irqs in the processor (if such mechanism on the processor).
*   
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
* Revision history:
*   date      Author    Comments
*   ------    ------    --------
*   130505    JT        Created
* 
************************************************************************************/
#define IrqControlLib_AckMC1319xIrq()						{ackMC1319xIrq();}

/***********************************************************************************/

//-----------------------------------------------------------------------------------

#endif /* _IRQCONTROLLIB_H_ */
